IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Asientos_Libro_Diario') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Asientos_Libro_Diario
END
GO


CREATE PROCEDURE [dbo].[CPJ_Asientos_Libro_Diario] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

DECLARE  @pFecha_Desde DATETIME
	    ,@pFecha_Hasta DATETIME
		,@pId_Plan_Cta INT
		,@pDetallado Tinyint
		,@pId_Unid_Negocio Varchar(10)

SET @pFecha_Desde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), GETDATE())
SET @pId_Plan_Cta				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Plan_Cta')), 0)
SET @pDetallado					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Detallado')), 0)
SET @pId_Unid_Negocio			= ISNULL(CONVERT(varchar(10), dbo.CF_JSON_VALUE(@pJson,'Id_Unid_Negocio')), '')

SELECT * INTO #UN FROM Empresas_Unid_Negocios
IF @pId_Unid_Negocio <> ''
   DELETE  #UN WHERE Id_Unid_Negocio <> @pId_Unid_Negocio

IF @pDetallado <> 1
   BEGIN
		select A.Fecha,A.Nro,A.Descripcion,A.Observacion,A.Importe,C.Nro_Cta_Contable,C.Descripcion as Nombre_Cta,A.Fecha as Fecha_cbte,CC.Descripcion as Centro_Costo,I.Debe,I.Haber,0 as Id_Trans,I.Item,'' as Descrip_Cbte
		from asientos a, asientos_items i, Pla_Ctas_Cuentas_Contables C, Centro_Costos CC,#UN U
		where a.id_asiento = i.id_asiento
		and i.Id_Cta_Contable = c.Id_Cta_Contable
		and i.Id_Centro_Costo = cc.Id_Centro_Costo
		and a.Id_Plan_Cta = @pId_Plan_Cta
		and balanceado = 1
		AND A.FECHA >= @pFecha_Desde 
		AND A.FECHA < dateadd(dd,1,@pFecha_Hasta)
		AND A.Id_Unid_Negocio = U.Id_Unid_Negocio
		order  BY  A.FECHA, A.Nro, i.item
   END
 ELSE
   BEGIN
		--- detallado
		select A.Fecha,A.Nro,A.Descripcion,A.Observacion,A.Importe,C.Nro_Cta_Contable,C.Descripcion as Nombre_Cta, kk.Fecha as Fecha_Cbte, CC.Descripcion as Centro_Costo,kk.Debe,kk.Haber, kk.id_trans,KK.Item
		into #Libro_Asientos
		from asientos a,  Pla_Ctas_Cuentas_Contables C, Centro_Costos CC, Cbtes K, Cbtes_Ctas_Contables KK, #UN U
		where K.id_Asiento = A.id_Asiento
		and k.Id_trans = KK.Id_Trans
		and A.Resumido = 1
		and kk.Id_Cta_Contable = c.Id_Cta_Contable
		and kk.Id_Centro_Costo = cc.Id_Centro_Costo
		and a.Id_Plan_Cta = @pId_Plan_Cta
		and a.balanceado = 1
		AND A.FECHA >= @pFecha_Desde 
		AND A.FECHA < dateadd(dd,1,@pFecha_Hasta)
		AND A.Id_Unid_Negocio = U.Id_Unid_Negocio


		select L.*, ISNULL(RTRIM(LTRIM(T.Descrip_Corta)), '')
				+ ' ' +ISNULL(RTRIM(LTRIM(T.Letra)), '') 
				+ ' ' + RIGHT('00000' + CAST(T.Id_Sucursal AS VARCHAR(5)), 5)
				+ '-' + RIGHT('00000000'+CAST(C.Comprobante_Nro AS VARCHAR(8)), 8) AS Comprobante_Nro
			Into #Detalle
			from #Libro_Asientos L, Cbtes C, Cbtes_Tipos T
			   Where C.Id_Trans = L.Id_Trans AND C.ID_TIPO_CBTE = T.ID_TIPO_CBTE

		Insert into #Detalle 
		select A.Fecha,A.Nro,A.Descripcion,A.Observacion,A.Importe,C.Nro_Cta_Contable,C.Descripcion as Nombre_Cta,A.Fecha as Fecha_cbte,CC.Descripcion as Centro_Costo,I.Debe,I.Haber,0 as Id_Trans,i.Item,'' as Descrip_Cbte
			from asientos a, asientos_items i, Pla_Ctas_Cuentas_Contables C, Centro_Costos CC, #UN U
			where a.id_asiento = i.id_asiento
			and i.Id_Cta_Contable = c.Id_Cta_Contable
			and i.Id_Centro_Costo = cc.Id_Centro_Costo
			and a.Id_Plan_Cta = @pId_Plan_Cta
			and balanceado = 1
			AND A.FECHA >= @pFecha_Desde 
			AND A.FECHA < dateadd(dd,1,@pFecha_Hasta)
			AND A.Id_Unid_Negocio = U.Id_Unid_Negocio

 
		select * from #Detalle order by  FECHA,Nro,item

		drop table #Libro_Asientos
		drop table #Detalle
   END
   DROP TABLE #UN


   /*

DECLARE @Param VARCHAR(5000)

SET @Param = '{' +
			'"Fecha_Desde":"20201201",' +
			'"Fecha_Hasta":"20210130",' +
			'"Id_Plan_Cta":"1",' +
			'"Detallado":"0",' +
			'"Id_Unid_Negocio":""' +
			'}'

EXEC CPJ_Asientos_Libro_Diario @Param

*/
